//
//  EsusAPI.h
//  Daemons
//
//  Created by Karl Løland on 10/18/11.
//  Copyright 2011 Altinett AS. All rights reserved.
//

#import <Foundation/Foundation.h>

@protocol EsusAPI <NSObject>

@required
#pragma MARK - ESUS
- (BOOL) registerClientWith: (NSString*) identifier installationID: (NSString*) instID productID: (NSString*) prodID appVersion: (NSString*) version bundlePath: (NSString*) path appBrand: (NSString*) brand;
- (BOOL) updateClient:(NSString*) identifier withBundePath: (NSString*) path andVersion: (NSString*) version;
- (BOOL) setRoaming: (BOOL) roaming;
- (void) forceCheck;
- (BOOL) uninstall: (NSString*) identifier;


#pragma MARK - ELAS
- (NSString*) registerApplicationWithIdentifier: (NSString*) identifier usingIccid: (NSString*) iccid imsi:(NSString*) imsi wlanMac:(NSString*)wMac mobileMac: (NSString*) mMac software:(NSString*) version previousVersion: (NSString*) pVers appBrand: (NSString*) brand bundlePath:(NSString*) path;

@optional
#pragma MARK - Optionals
- (void) syslog: (NSString*) string;
- (NSString*) echo: (NSString*) string;
@end
